/**
* \file: am_api_fsm.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AM_API_FSM_H
#define AM_API_FSM_H

#include <stdbool.h>

#include "automounter_api.h"

error_code_t am_api_fsm_signal_init_request(const char *app_identifer,
		logger_loglevel_t loglevel, bool console_log_enabled);

void am_api_fsm_signal_deinit_request(void);

error_code_t am_api_fsm_signal_connect_request(void);

error_code_t am_api_fsm_signal_try_connect_request(void);

void am_api_fsm_signal_disconnect_request(void);

void am_api_fsm_signal_connection_lost(void);

automounter_api_state_t am_api_fsm_get_state(void);

bool am_api_fsm_is_connection_failure(void);

void am_api_fsm_signal_automounter_appeared(void);

void am_api_fsm_signal_callbacks_changed(void);

#endif
